  <?php require ("header.php")?>
  
 
  <?php
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


$deleted = false; // flag to indicate successful delete

if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $id = (int) $_GET['delete'];

    $stmt = $pdo->prepare("DELETE FROM message WHERE id = :id");
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();

    $deleted = true;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Inbox</title>
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" />
<style>
    body { font-size: 18px; background-color: #f8f9fa; }
    h2 { font-size: 32px; text-align: center; margin-bottom: 40px; }
    .message-wrapper { max-width: 700px; margin: 0 auto 30px; }
    .media {
        padding: 25px;
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 12px;
        text-align: center;
    }
    .media img {
        width: 70px;
        height: 70px;
        object-fit: cover;
        margin: 0 auto 15px;
        border-radius: 50%;
    }
    h5 { font-size: 22px; font-weight: bold; }
    p { font-size: 20px; }
    .btn-group > a { margin: 0 5px 10px; }
</style>
<script>
function confirmDelete(id) {
    if (confirm('Are you sure you want to delete this message?')) {
        // Redirect to delete URL
        window.location.href = 'inbox.php?delete=' + id;
    }
}
</script>
</head>
<body>

<div class="container mt-5">
    <h2>Inbox Mails (
        <?php
        $stmt = $pdo->query("SELECT COUNT(id) FROM message");
        echo $stmt->fetchColumn();
        ?> )
    </h2>

    <div class="text-center mb-4">
        <a href="index.php" class="btn btn-primary">Back to Home</a>
    </div>

    <?php
    $stmt = $pdo->query("SELECT * FROM message ORDER BY id DESC");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($row['status'] == 0) {
            $imgSrc = ($row['photo'] == 1 && !empty($row['P_location']))
                ? "../" . htmlspecialchars($row['P_location'])
                : "../accounts/upload/photo/default.png";

            echo "
            <div class='message-wrapper'>
                <div class='media flex-column align-items-center'>
                    <img src='" . $imgSrc . "' alt='User Photo' />
                    <div class='media-body'>
                        <h5>" . htmlspecialchars($row['name']) . "</h5>
                        <p>" . nl2br(htmlspecialchars($row['msg'])) . "</p>
                        <small class='text-muted d-block mb-3'>" . htmlspecialchars($row['date']) . "</small>
                        <div class='btn-group'>
                            <a href='reply_inbox.php?id=" . $row['id'] . "' class='btn btn-info btn-sm'>View</a>
                            <a href='reply_inbox.php?id=" . $row['id'] . "' class='btn btn-success btn-sm'>Reply</a>
                            <a href='javascript:void(0);' onclick='confirmDelete(" . $row['id'] . ")' class='btn btn-danger btn-sm'>Delete</a>
                        </div>
                    </div>
                </div>
            </div>";
        }
    }
    ?>
</div>

<?php if ($deleted): ?>
<script>
    alert("Message deleted!");
    window.location.href = "index.php";
</script>
<?php endif; ?>

</body>
</html>

           
             <?php require ("footer.php")?>