 <?php
session_start();

require_once("../config.php");


// Check if user is logged in
if (!isset($_SESSION['SESS_LOGGEDIN']) || $_SESSION['SESS_LOGGEDIN'] !== true) {
    header("Location: " . $config_basedir . "logout.php");
    exit();
}
?>

<!--=============================-->

<?php

// Check if user is logged in
if (!isset($_SESSION['SESS_USERID'])) {
    header("Location: logout.php");
    exit();
}

$id = $_SESSION['SESS_USERID'];

// Use PDO for secure database access
$stmt = $pdo->prepare("SELECT status FROM logins WHERE id = :id");
$stmt->execute(['id' => $id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    switch ($user['status']) {
        case 1:
            header("Location: acc_onhold.php");
            exit();
        case 2:
            header("Location: acc_deactivated.php");
            exit();
        case 3:
            header("Location: acc_suspecious_login.php");
            exit();
        case 4:
            header("Location: acc_freezed.php");
            exit();
        // You can add a default case if needed
    }
} else {
    // Handle invalid user ID
    echo "Invalid user ID.";
    exit();
}
?>



<!--=================================-->


 
 

 
 <?php

// Fetch user record
$stmt = $pdo->prepare("SELECT * FROM logins WHERE id = ?");
$stmt->execute([$id]);
$numrow = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$numrow) {
    die("User not found.");
}

// Currency ID from user
$curren = $numrow['currency'];

// Exchange rates (example, use dynamic values if needed)
$rates = [
    1 => 1,
    2 => $GBP,
    3 => $EUR,
    4 => $AUD,
    5 => $CAD,
    6 => $CNY,
    7 => $ZAR,
    8 => $NGN,
    9 => $GHS,
    10 => $JPY,
    11 => $KRW,
    12 => $TWD,
    13 => $THB,
    14 => $MYR,
    15 => $BRL,
    16 => $ARS,
    17 => $PHP,
    18 => $AED
];

// Currency names (optional)
$currencyNames = [
    1 => 'USD',
    2 => 'GBP',
    3 => 'EUR',
    4 => 'AUD',
    5 => 'CAD',
    6 => 'CNY',
    7 => 'ZAR',
    8 => 'NGN',
    9 => 'GHS',
    10 => 'JPY',
    11 => 'KRW',
    12 => 'TWD',
    13 => 'THB',
    14 => 'MYR',
    15 => 'BRL',
    16 => 'ARS',
    17 => 'PHP',
    18 => 'AED'
];

// Currency symbols (HTML entities)
$symbols = [
    1 => '&#36;',    // USD
    2 => '&#163;',   // GBP
    3 => '&#8364;',  // EUR
    4 => '&#8371;',  // AUD (same as PHP)
    5 => '&#36;',    // CAD
    6 => '&#165;',   // CNY
    7 => '&#82;',    // ZAR (symbol used can vary)
    8 => '&#8358;',  // NGN
    9 => '&#8373;',  // GHS
    10 => '&#165;',  // JPY
    11 => '&#8361;', // KRW
    12 => '&#78;',   // TWD
    13 => '&#3647;', // THB
    14 => '&#77;',   // MYR
    15 => '&#82;',   // BRL
    16 => '&#36;',   // ARS
    17 => '&#8369;', // PHP
    18 => '&#x625;'  // AED
];

// Get exchange rate
$rate = $rates[$curren] ?? 1;

// Calculate balances
$ibalc = $numrow['ibalance'] * $rate;
$balc  = $numrow['balance'] * $rate;
$bloan = $numrow['loan'] * $rate;


$cur = $currencyNames[$curren] ?? 1;

$curr = $symbols[$curren] ?? 1;


$sex = $numrow['sex'];
$firstname = $numrow['firstname'];
$lastname = $numrow['lastname'];
$username = $numrow['username'];
$phone = $numrow['phone'];
$email = $numrow['email'];
$m_status = $numrow['m_status'];
$dob = $numrow['dob'];
$address = $numrow['address'];
$gender = $numrow['gender'];
$acc_no = $numrow['acc_no'];
$fax = $numrow['fax'];
$status = $numrow['status'];
$verified = $numrow['verified'];
$date = $numrow['date'];


$country = $numrow['country'];
$state = $numrow['state'];
$city = $numrow['city'];
$p_code = $numrow['p_code'];
$pin = $numrow['pin'];
$c_pin = $numrow['c_pin'];
$c_sum = $numrow['c_sum'];

$invbalc = $numrow['invbalc'];
$totwid = $numrow['totwid'];
$newwid = $numrow['newwid'];
$opbalc = $numrow['opbalc'];
$deposit = $numrow['deposit'];

$credit = $numrow['credit'];
$debit = $numrow['debit'];


$CARD = $numrow['CARD'];
$EXP = $numrow['EXP'];
$CVV = $numrow['CVV'];
$CARD_TYP = $numrow['CARD_TYP'];
$card_balc = $numrow['card_balc'];

$ibalance = $numrow['ibalance'];
$balance = $numrow['balance'];
$pendng = $numrow['rbalance'];
$mybtc = $numrow['mybtc'];


$billing = $numrow['billing']; 
  
  $bill = $numrow['bill'];
                                   
$fee1 = $numrow['fee1'];
$fee2 = $numrow['fee2'];
$fee3 = $numrow['fee3'];
$fee4 = $numrow['fee4'];
$fee5 = $numrow['fee5'];
$fee6 = $numrow['fee6'];
$fee7 = $numrow['fee7'];
$fee8 = $numrow['fee8'];
$fee9 = $numrow['fee9'];
$fee10 = $numrow['fee10'];

$b1 = $numrow['b1'];
$b2 = $numrow['b2'];
$b3 = $numrow['b3'];
$b4 = $numrow['b4'];
$b5 = $numrow['b5'];
$b6 = $numrow['b6'];
$b7 = $numrow['b7'];
$b8 = $numrow['b8'];
$b9 = $numrow['b9'];
$b10 = $numrow['b10'];
             
    
$bs1 = $numrow['bs1'];
$bs2 = $numrow['bs2'];
$bs3 = $numrow['bs3'];
$bs4 = $numrow['bs4'];
$bs5 = $numrow['bs5'];
$bs6 = $numrow['bs6'];
$bs7 = $numrow['bs7'];
$bs8 = $numrow['bs8'];
$bs9 = $numrow['bs9'];
$bs10 = $numrow['bs10'];
                      
             
              $fe1=$numrow['fe1'];
             $fe2=$numrow['fe2'];
             $fe3=$numrow['fe3'];
             $fe4=$numrow['fe4'];
             $fe5=$numrow['fe5'];
             $fe6=$numrow['fe6'];
             $fe7=$numrow['fe7'];
             $fe8=$numrow['fe8'];
             $fe9=$numrow['fe9'];
             $fe10=$numrow['fe10'];
             

// $fee1 = $numrow['fee1'];
$pint = $numrow['pint'];
$pint_status = $numrow['pint_status'];


$currency = $numrow['currency'];
$ann_incom = $numrow['ann_incom'];
$biz_type = $numrow['biz_type'];
$company_name = $numrow['company_name'];
$occupation = $numrow['occupation'];

$id_type = $numrow['id_type'];
$id_expired = $numrow['id_expired'];
$id_no = $numrow['id_no'];
$acc_type = $numrow['acc_type'];
$status = $numrow['status'];
$password = $numrow['password'];

$tr_limit = $numrow['tr_limit'];
$t_funding = $numrow['t_funding'];
$tr_dailylimit = $numrow['tr_dailylimit'];
$t_trans = $numrow['t_trans'];
$t_withdraw = $numrow['t_withdraw'];
$loan = $numrow['loan'];
$last_login = $numrow['last_login'];

          
             
                              

 ?>  
 
 
 
 
 
 
 
 
 
 
 
 
 
 <?php

$id = $_SESSION['SESS_USERID'] ?? null;
if (!$id) {
    die('User not logged in.');
}

// Fetch user data
$stmt = $pdo->prepare("SELECT * FROM logins WHERE id = ?");
$stmt->execute([$id]);
$serow = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$serow) {
    die('User not found.');
}











 // ===============START==MESSAGE======================================


// SEND MESSAGE
if (isset($_POST['action_msg'])) {
    $fields = ['cname', 'cemail', 'cphone', 'caddress', 'name', 'email', 'title', 'phone', 'acc_no', 'curr', 'amount', 'msg', 'ticket_id', 'date'];
    $data = [];
    foreach ($fields as $field) {
        $data[$field] = htmlspecialchars(trim($_POST[$field] ?? ''));
    }

    $stmt = $pdo->prepare("INSERT INTO message (log_id, title, name, date, msg, curr, amount, email, acc_no, phone, ticket_id, status)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0)");
    $stmt->execute([$id, $data['title'], $data['name'], $data['date'], $data['msg'], $data['curr'], $data['amount'], $data['email'], $data['acc_no'], $data['phone'], $data['ticket_id']]);

    echo "<center><div class='warning'><img src='tools/progress-bar.gif'/><meta http-equiv='refresh' content='5; url=ticket.php' /></div></center>";
}




 // ===============END==MESSAGE======================================



























 // ===============START==PHOTO======================================


// HANDLE PHOTO UPLOAD
if (isset($_POST['photo_action'])) {
    $uploadDir = 'accounts/upload/photo/';
    $file = $_FILES['imgfile'] ?? null;

    if ($file && in_array(strtolower(pathinfo($file['name'], PATHINFO_EXTENSION)), ['jpg','jpeg','png','gif','jfif'])) {
        if ($file['size'] < 104857600 && $file['size'] > 0) {
            $filePath = $uploadDir . basename($file['name']);
            if (move_uploaded_file($file['tmp_name'], "../" . $filePath)) {
                // Update the database with the new photo path
                $stmt = $pdo->prepare("UPDATE logins SET P_location=?, photo=1 WHERE id=?");
                $stmt->execute([$filePath, $id]);

                // JavaScript alert for successful upload
                echo "<script type='text/javascript'>alert('Your photo has been successfully uploaded!');</script>";

                // Optionally, you can include a success message or a refresh
             
            } else {
                echo "<script type='text/javascript'>alert('There was an error uploading your file. Please try again.');</script>";
            }
        } else {
            echo "<script type='text/javascript'>alert('File size must be less than 100MB.');</script>";
        }
    } else {
        echo "<script type='text/javascript'>alert('Invalid file type. Only JPG, JPEG, PNG, GIF, and JFIF are allowed.');</script>";
    }
}


 // ===============END==PHOTO======================================



















 // ===============START==IDFRONT======================================


// HANDLE ID FRONT UPLOAD
if (isset($_POST['idF_action'])) {
    $uploadDir = 'accounts/upload/doc/';
    $file = $_FILES['doc'] ?? null;

    if ($file && in_array(strtolower(pathinfo($file['name'], PATHINFO_EXTENSION)), ['jpg','jpeg','png','gif','jfif'])) {
        if ($file['size'] < 104857600 && $file['size'] > 0) {
            $filePath = $uploadDir . basename($file['name']);
            move_uploaded_file($file['tmp_name'], "../" . $filePath);
            $stmt = $pdo->prepare("UPDATE logins SET DF_Location=?, idF=1 WHERE id=?");
            $stmt->execute([$filePath, $id]);
            echo "<div class='alert alert-success'>ID Front Uploading...<meta http-equiv='refresh' content='7; url=upload_doc2.php' /><img src='tools/verifying-id-card.gif'/></div>";
        }
    }
}


 // ===============END==IDFRONT======================================




















 // ===============START==IDBACK======================================


// HANDLE ID BACK UPLOAD
if (isset($_POST['idB_action'])) {
    $uploadDir = 'accounts/upload/doc2/';
    $file = $_FILES['doc2'] ?? null;

    if ($file && in_array(strtolower(pathinfo($file['name'], PATHINFO_EXTENSION)), ['jpg','jpeg','png','gif','jfif'])) {
        if ($file['size'] < 104857600 && $file['size'] > 0) {
            $filePath = $uploadDir . basename($file['name']);
            move_uploaded_file($file['tmp_name'], "../" . $filePath);
            $stmt = $pdo->prepare("UPDATE logins SET DB_Location=?, idB=1 WHERE id=?");
            $stmt->execute([$filePath, $id]);
            echo "<div class='alert alert-success'>ID Back Uploading...<meta http-equiv='refresh' content='7; url=index.php' /><img src='tools/verifying-id-card.gif'/></div>";
        }
    }
}

 
 // ===============END==IDBACK======================================

 
 
 
 
 
 
 
 
 
 // ===============START==PIN======================================


 
// PIN update
if (isset($_POST['action_pin'])) {
    $username = htmlspecialchars($_POST['username']);
    $pin = htmlspecialchars($_POST['pin']);
    $cpin = htmlspecialchars($_POST['cpin']);

    // Verify the user's current pin
    $stmt = $pdo->prepare("SELECT * FROM logins WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Verify the current pin
        if ($pin === $user['pin']) {
            // Update pin in the database
            $updateStmt = $pdo->prepare("UPDATE logins SET pin = ? WHERE id = ?");
            if ($updateStmt->execute([$cpin, $user['id']])) {
                $success_pin = "<div class='alert alert-success' style='margin-bottom:20px;'>Pin updated successfully <meta http-equiv='refresh' content='5; url=index.php' /></div>";
            } else {
                $error_pin = "<div class='alert alert-danger' align='center'>Error updating pin!</div>";
            }
        } else {
            $error_pin = "<div class='alert alert-danger' align='center'>Incorrect Pin/Username!</div>";
        }
    } else {
        $error_pin = "<div class='alert alert-danger' align='center'>User not found!</div>";
    }
}



 // ===============END==PIN======================================


















// =======CREATE==CARD==============================


// Card creation
if (isset($_POST['action_card'])) {
    $id = $_SESSION['SESS_USERID'];
    $name = htmlspecialchars($_POST['name']);
    $phone = htmlspecialchars($_POST['phone']);
    $email = htmlspecialchars($_POST['email']);
    $acc_no = htmlspecialchars($_POST['acc_no']);
    $CVV = htmlspecialchars($_POST['CVV']);
    $EXP = htmlspecialchars($_POST['EXP']);
    $CARD_TYP = htmlspecialchars($_POST['CARD_TYP']);
    $CARD = htmlspecialchars($_POST['CARD']);
    $card_balc = htmlspecialchars($_POST['card_balc']);
    $card_date = htmlspecialchars($_POST['card_date']);
    $CARDstatus = htmlspecialchars($_POST['CARDstatus']);

    // Update card details in the database
    $updateStmt = $pdo->prepare("UPDATE logins SET CVV = ?, EXP = ?, card_date = ?, CARD_TYP = ?, CARD = ?, CARDstatus = ? WHERE id = ?");
    if ($updateStmt->execute([$CVV, $EXP, $card_date, $CARD_TYP, $CARD, $CARDstatus, $id])) {
        $success_card = "<center><div class='warning' style='margin-bottom:50px;'><img src='tools/progress-bar.gif' style='max-width:1000px;'/><meta http-equiv='refresh' content='5; url=' /></div></center>";
    } else {
        $error_card = "<div class='alert alert-danger' align='center'>Error updating card details!</div>";
    }
}
// ==========END==CREATE==CARD================================





















// ===============FUND==CARD======================================


// Fund card
if (isset($_POST['fund_card'])) {
    $id = $_SESSION['SESS_USERID'];
    $cardbl = htmlspecialchars($_POST['card_balc']);
    
    // Fetch the user's current balance
    $stmt = $pdo->prepare("SELECT balance, card_balc FROM logins WHERE id = ?");
    $stmt->execute([$id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        if ($user['balance'] >= $cardbl) {
            // Update card balance
            $updateStmt = $pdo->prepare("UPDATE cards SET card_balc = card_balc + ? WHERE id = ?");
            $updateStmt->execute([$cardbl, $id]);

            // Deduct from user's balance
            $updateBalanceStmt = $pdo->prepare("UPDATE logins SET balance = balance - ? WHERE id = ?");
            $updateBalanceStmt->execute([$cardbl, $id]);

            $success_fund = "<center><div class='warning' style='margin-bottom:50px;'><img src='tools/progress-bar.gif' style='max-width:1000px;'/><meta http-equiv='refresh' content='5; url=' /></div></center>";
        } else {
            $error_fund = "<div class='alert alert-danger' align='center'>Insufficient funds!</div>";
        }
    }
}



// ============END===FUND==CARD======================================



















// =======DISABLE===CARD================================


// Disable card
if (isset($_POST['dis_card'])) {
    $id = $_SESSION['SESS_USERID'];
    $CARDstatus = htmlspecialchars($_POST['CARDstatus']);

    // Update card status in the database
    $updateStmt = $pdo->prepare("UPDATE logins SET CARDstatus = ? WHERE id = ?");
    if ($updateStmt->execute([$CARDstatus, $id])) {
        $success_disable = "<center><div class='warning' style='margin-bottom:50px;'><img src='tools/progress-bar.gif' style='max-width:1000px;'/><meta http-equiv='refresh' content='5; url=' /></div></center>";
    } else {
        $error_disable = "<div class='alert alert-danger' align='center'>Error disabling card!</div>";
    }
}




// ===============END==CARD==============================








 
 
 
 
 
//  =================password====================================
 
 
if (isset($_POST['password_action'])) {
    $username = htmlspecialchars($_POST['username']);
    $password = htmlspecialchars($_POST['password']);
    $cpassword = htmlspecialchars($_POST['cpassword']);

    // Verify the user's current password
    $stmt = $pdo->prepare("SELECT * FROM logins WHERE username = ?");
    $stmt->execute([$username]);
   
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Verify the current password
        if (password_verify($password, $user['password'])) {
            // Hash the new password before storing it
            $hashedPassword = password_hash($cpassword, PASSWORD_DEFAULT);

            // Update password in the database
            $updateStmt = $pdo->prepare("UPDATE logins SET password = ? WHERE id = ?");
            if ($updateStmt->execute([$hashedPassword, $user['id']])) {
                $success_password = "<div class='alert alert-success' style='margin-bottom:20px;'>Password updated successfully <meta http-equiv='refresh' content='5; url=index.php' /></div>";
            } else {
                $error_password = "<div class='alert alert-danger' align='center'>Error updating password!</div>";
            }
        } else {
            $error_password = "<div class='alert alert-danger' align='center'>Incorrect password/Username!</div>";
        }
    } else {
        $error_password = "<div class='alert alert-danger' align='center'>User not found!</div>";
    }
}



?>

 <!--======================================-->
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
<!DOCTYPE html>
<html lang="zxx" class="js dark-mode">

<head>

    <meta charset="utf-8">
<meta name="author" content="Garantii Finance">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<meta name="description" content="Easy, fee-free banking for entrepreneurs">
<!--<meta name="csrf-token" content="wnNSTi4rAmPNuX7vU8gTtYTvQSUuk8twFcHNmXkN">-->

<title>MyAccount | <?php echo $fullname ?> | <?php echo $title ?></title> 
<!-- Fav Icon  -->
<link rel="shortcut icon" href="<?php echo $url ?>/img/favicon.png">

    <!-- StyleSheets  -->
    <link rel="stylesheet" href="backend/user/assets/css/dashlite.css">
    <link id="skin-default" rel="stylesheet" href="backend/user/assets/css/theme.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;700&display=swap" rel="stylesheet">





<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <script src='https://kit.fontawesome.com/a076d05399.js' crossorigin='anonymous'></script>
    
    
    <link rel="shortcut icon" href="appImages/settings/ca9MzWpmU95gPgo8oUD7PSHkJEu30kYH297700011752favicon.png">

    <!-- StyleSheets  -->
    <link rel="stylesheet" href="backend/user/assets/css/dashlite.css?ver=3.1.1">
    <link id="skin-default" rel="stylesheet" href="backend/user/assets/css/theme.css?ver=3.1.1">
    
    
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Josefin+Sans:wght@400;500;600;700&display=swap");

        *{
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Josefin Sans', san-serif;

        }

        .mycontainer{
            min-height: 100vh;
            width: 100%;
            background: #000;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .mycard{
            width: auto;
            max-width: 500px;
            height: 300px;
            color: #fff;
            cursor: pointer;
            perspective: 1000px;
        }

        .mycard-inner{
            width: 100%;
            height: 100%;
            position: relative;
            transition: transform 1s;
            transform-style: preserve-3d;
        }

        .front, .back{
            width: 100%;
            height: 100%;
            background-image: linear-gradient(45deg, #0045c7, #ff2c7d);
            position: absolute;
            top: 0;
            left: 0;
            padding: 20px 30px;
            border-radius: 15px;
            /* overflow: hidden; */
            z-index: 1;
            backface-visibility: hidden;
        }

        .myrow{
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .map-img{
            width: 100%;
            position: absolute;
            top: 0;
            left: 0;
            opacity: 0.3;
            z-index: -1;
        }

        .mycard-no{
            font-size: 35px;
            margin-top: 40px;
        }

        .mycard-holder{
            font-size: 12px;
            margin-top: 15px;
            margin-bottom: 0;
        }

        .myname{
            font-size: 22px;
            /* margin-bottom: 10px; */
            margin-top: -8px;
        }

        .bar{
            background: #222;
            margin-left: -30px;
            margin-right: -30px;
            height: 45px;
            /* margin-top: 10px; */
        }

        .code{
            text-align: right;

        }

        .mycard-cvv{
            margin-top: 20px;
        }

        .mycard-cvv div{
            flex: 1;
        }

        .mycard-cvv img{
            width: 100%;
            display: block;
            line-height: 0;
        }

        .mycard-cvv p{
            height: 51px;
            /* background: #fff; */
            color: #fff;
            font-size: 18px;
            padding: 10px 15px 8px 15px;
            margin-top: 5px;
            margin-bottom: -3px;
        }

        .mycard-text{
            margin-top: 10px;
            font-size: 13px;
            font-weight: bold;
            line-height: 12px;
            text-align: left;
            color: #000;
        }

        .signature{
            margin-top: 0;
        }


        .back{
            transform: rotateY(180deg);
        }

        .mycard:hover .mycard-inner{
            transform: rotateY(-180deg);
        }
    </style>

    
    <style >[wire\:loading], [wire\:loading\.delay], [wire\:loading\.inline-block], [wire\:loading\.inline], [wire\:loading\.block], [wire\:loading\.flex], [wire\:loading\.table], [wire\:loading\.grid], [wire\:loading\.inline-flex] {display: none;}[wire\:loading\.delay\.shortest], [wire\:loading\.delay\.shorter], [wire\:loading\.delay\.short], [wire\:loading\.delay\.long], [wire\:loading\.delay\.longer], [wire\:loading\.delay\.longest] {display:none;}[wire\:offline] {display: none;}[wire\:dirty]:not(textarea):not(input):not(select) {display: none;}input:-webkit-autofill, select:-webkit-autofill, textarea:-webkit-autofill {animation-duration: 50000s;animation-name: livewireautofill;}@keyframes livewireautofill { from {} }</style>
    
    
    
   

</head>

<body class="nk-body npc-crypto bg-white has-sidebar ">
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <!-- sidebar @s -->

          
          
          
          
          
          
          
          
          
          
            <div class="nk-sidebar nk-sidebar-fixed " data-content="sidebarMenu">
    <div class="nk-sidebar-element nk-sidebar-head">
        <div class="nk-sidebar-brand">
            <a href="index.php" class="logo-link nk-sidebar-logo">
                <img class="logo-light logo-img" src="<?php echo $url ?>/img/LOGO.png" alt="logo">
                <img class="logo-dark logo-img" src="<?php echo $url ?>/img/LOGO.png"  alt="logo">
            </a>
        </div>
        <div class="nk-menu-trigger me-n2">
            <a href="#" class="nk-nav-toggle nk-quick-nav-icon d-xl-none" data-target="sidebarMenu"><em class="icon ni ni-arrow-left"></em></a>
        </div>
    </div><!-- .nk-sidebar-element -->
    <div class="nk-sidebar-element">
        <div class="nk-sidebar-body" data-simplebar>
            <div class="nk-sidebar-content">
                <div class="nk-sidebar-widget d-xl-block">
                    <div class="user-account-info between-center">
                        <div class="user-account-main">
                            <h6 class="overline-title-alt">Available Balance</h6>
                            <div class="user-balance"> <?php echo $curr ?> <?php echo number_format($balc,2) ?> </div>
                            
                        </div>
                        <a href="#" class="btn btn-white btn-icon btn-light"><em class="icon ni ni-line-chart"></em></a>
                    </div>
                    <ul class="user-account-data gy-1">
                        <li>
                            <div class="user-account-label">
                                <span class="sub-text">Account Status</span>
                            </div>
                            <div class="user-account-value">
                                
                                                                    <span class="text-success ms-2"> Active </span>
                                
                            </div>
                        </li>

                        
                    </ul>
                    <div class="user-account-actions">
                        <ul class="g-3">
                            <li><a href="funds_transfer.php" class="btn btn-lg btn-primary"><span>Transfer</span></a></li>
                            <li><a href="e_statement.php" class="btn btn-lg btn-warning"><span>History</span></a></li>
                        </ul>
                    </div>
                </div><!-- .nk-sidebar-widget -->

                

                <div class="nk-sidebar-menu">
                    <!-- Menu -->
                    <ul class="nk-menu">
                        <li class="nk-menu-heading">
                            <h6 class="overline-title">Menu</h6>
                        </li>
                        <li class="nk-menu-item">
                            <a href="dashboard.php" class="nk-menu-link">
                                <span class="nk-menu-icon"><em class="icon ni ni-dashboard"></em></span>
                                <span class="nk-menu-text">Dashboard</span>
                            </a>
                        </li>
                        
                        <li class="nk-menu-item">
                            <a href="profile.php" class="nk-menu-link">
                                <span class="nk-menu-icon"><em class="icon ni ni-account-setting"></em></span>
                                <span class="nk-menu-text"> Profile</span>
                            </a>
                        </li>
                        <li class="nk-menu-item">
                            <a href="card.php" class="nk-menu-link">
                                <span class="nk-menu-icon"><em class="icon ni ni-cc-secure-fill"></em></span>
                                <span class="nk-menu-text">Card(s)</span>
                            </a>
                        </li>
                        <li class="nk-menu-item has-sub">
                            <a href="#" class="nk-menu-link nk-menu-toggle">
                                <span class="nk-menu-icon"><em class="icon ni ni-repeat"></em></span>
                                <span class="nk-menu-text">Transactions</span>
                            </a>
                            <ul class="nk-menu-sub">
                                <li class="nk-menu-item">
                                    <a href="funds_transfer.php" class="nk-menu-link"><span class="nk-menu-text">Funds Transfer</span></a>
                                </li>
                                <li class="nk-menu-item">
                                    <a href="e_statement.php" class="nk-menu-link"><span class="nk-menu-text">Transaction History</span></a>
                                </li>
                            </ul><!-- .nk-menu-sub -->
                        </li><!-- .nk-menu-item -->
                        
                        
                         <li class="nk-menu-item has-sub">
                            <a href="#" class="nk-menu-link nk-menu-toggle">
                               <span class="nk-menu-icon"><em class="icon ni ni-bell"></em></span>
                                <span class="nk-menu-text">Support</span>
                            </a>
                            <ul class="nk-menu-sub">
                                <li class="nk-menu-item">
                                    <a href="inbox.php" class="nk-menu-link"><span class="nk-menu-text">InBox </span></a>
                                </li>
                                <li class="nk-menu-item">
                                    <a href="outbox.php" class="nk-menu-link"><span class="nk-menu-text">OutBOX</span></a>
                                </li>
                                
                                <li class="nk-menu-item">
                                    <a href="support.php" class="nk-menu-link"><span class="nk-menu-text">Write</span></a>
                                </li>
                            </ul><!-- .nk-menu-sub -->
                        </li><!-- .nk-menu-item -->
                        
                        
                        
                        
                        
                        <li class="nk-menu-item">
                                    <a href="logout.php" class="nk-menu-link">
                                      <span class="nk-menu-icon"><em class="icon ni ni-bell"></em></span>
                                        <span class="nk-menu-text">Log Out </span></a>
                                </li>
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                      
                        
                       
                      

                    </ul><!-- .nk-menu -->
                </div><!-- .nk-sidebar-menu -->

               
           
            </div><!-- .nk-sidebar-content -->
        </div><!-- .nk-sidebar-body -->
    </div><!-- .nk-sidebar-element -->
</div>

            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->

               
               
               
               
               
               
               
               
               
             <?php
// Assuming $pdo, $id, $firstname, $lastname, $email, $balc, $acc_no, $curr, $url are defined before this
// Fetch user data once
$stmt = $pdo->prepare("SELECT * FROM logins WHERE id = ?");
$stmt->execute([$id]);
$userrow = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="nk-header nk-header-fluid nk-header-fixed is-light">
    <div class="container-fluid">
        <div class="nk-header-wrap">
            <div class="nk-menu-trigger d-xl-none ms-n1">
                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em class="icon ni ni-menu"></em></a>
            </div>
            <div class="nk-header-brand d-xl-none">
                <a href="index.php" class="logo-link">
                    <img class="logo-light logo-img" src="<?= $url ?>/img/LOGO.png" alt="logo">
                    <img class="logo-dark logo-img" src="<?= $url ?>/img/LOGO.png" alt="logo">
                </a>
            </div>

            <div class="nk-header-news d-none d-xl-block"></div>

            <div class="nk-header-tools">
                <ul class="nk-quick-nav">

                    <!-- User Dropdown -->
                    <li class="dropdown user-dropdown">
                        <a href="#" class="dropdown-toggle" data-bs-toggle="dropdown">
                            <div class="user-toggle">
                                <div class="user-avatar sm text-justify-center">
                                    <?php if ($userrow && $userrow['photo'] == 0): ?>
                                        <img class="navbar-brand-img" width="100%" src="upload/photo/default.png" alt="<?= htmlspecialchars($userrow['username']) ?>">
                                    <?php elseif ($userrow && $userrow['photo'] == 1): ?>
                                        <img class="navbar-brand-img" width="100%" src="../<?= htmlspecialchars($userrow['P_location']) ?>" alt="<?= htmlspecialchars($userrow['username']) ?>">
                                    <?php endif; ?>
                                </div>
                                <div class="user-info d-none d-md-block">
                                    <div class="user-status user-status-verified">Online</div>
                                    <div class="user-name dropdown-indicator"><?= htmlspecialchars($firstname . ' ' . $lastname) ?></div>
                                </div>
                            </div>
                        </a>

                        <div class="dropdown-menu dropdown-menu-md dropdown-menu-end dropdown-menu-s1">
                            <div class="dropdown-inner user-card-wrap bg-lighter d-none d-md-block">
                                <div class="user-card">
                                    <div class="user-avatar md text-justify-center">
                                        <img src="images/WYs46YCIT06Xj9ZJ2OquGQLIoilavt57NaV2vDGI.jpg" alt="User Image">
                                    </div>
                                    <div class="user-info">
                                        <span class="lead-text"><?= htmlspecialchars($firstname . ' ' . $lastname) ?></span>
                                        <span class="sub-text"><?= htmlspecialchars($email) ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="dropdown-inner user-account-info">
                                <h6 class="overline-title-alt">Account Balance</h6>
                                <div class="user-balance"><?php echo $curr ?> <?php echo number_format($balc,2) ?> <small class="currency currency-btc"><?php echo $cur ?></small></div>
                                <div class="user-balance-sub">Account Number <span><?= htmlspecialchars($acc_no) ?></span></div>
                                <a href="funds_transfer.php" class="link"><span>Funds Transfer</span> <em class="icon ni ni-wallet-out"></em></a>
                            </div>
                            <div class="dropdown-inner">
                                <ul class="link-list">
                                    <li><a href="profile.php"><em class="icon ni ni-user-alt"></em><span>View Profile</span></a></li>
                                </ul>
                            </div>
                            <div class="dropdown-inner">
                                <ul class="link-list">
                                    <li>
                                        <a href="logout.php" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                            <em class="icon ni ni-signout"></em><span>Log Out</span>
                                        </a>
                                        <form action="logout.php" id="logout-form" method="post">
                                            <!-- Use real CSRF token here if available -->
                                            <input type="hidden" name="_token" value="<?= htmlspecialchars(session_id()) ?>">
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </li>

                    <!-- Notification Dropdown -->
                    <li class="dropdown notification-dropdown me-n1">
                        <a href="#" class="dropdown-toggle nk-quick-nav-icon" data-bs-toggle="dropdown">
                            <div class="icon-status icon-status-info"><em class="icon ni ni-bell"></em></div>
                        </a>

                        <div class="dropdown-menu dropdown-menu-xl dropdown-menu-end dropdown-menu-s1">
                            <div class="dropdown-head">
                                <span class="sub-title nk-dropdown-title">Notifications</span>
                                <a href="#">Mark All as Read</a>
                            </div>
                            <div class="dropdown-body">
                                <div class="nk-notification">
                                    <?php
                                    $stmt = $pdo->prepare("SELECT * FROM message WHERE log_id = ? ORDER BY id DESC LIMIT 1000");
                                    $stmt->execute([$id]);
                                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) :
                                        ?>
                                        <a href="reply_inbox.php?id=<?= $row['id'] ?>">
                                            <div class="nk-notification-item dropdown-inner">
                                                <div class="nk-notification-icon">
                                                    <?php if ($row['photo'] == 0): ?>
                                                        <img src="../accounts/upload/photo/default.png" class="rounded-circle" alt="User" style="width:50px;height:50px">
                                                    <?php elseif ($row['photo'] == 1): ?>
                                                        <img src="../<?= htmlspecialchars($row['P_location']) ?>" class="rounded-circle" alt="User" style="width:50px;height:50px">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="nk-notification-content">
                                                    <div class="nk-notification-text"><?= htmlspecialchars($row['title']) ?></div>
                                                    <span>Dear <?= htmlspecialchars($row['name']) ?>, <?= htmlspecialchars(substr($row['msg'], 0, 40)) ?>...</span>
                                                    <div class="nk-notification-time"><?= htmlspecialchars($row['date']) ?></div>
                                                </div>
                                            </div>
                                        </a>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                            <div class="dropdown-foot center">
                                <a href="inbox.php">View All</a>
                            </div>
                        </div>
                    </li>

                </ul>
            </div>
        </div>
    </div>
</div>
