<?php require ("header.php") ?>

                <!-- main header @e -->
                <!-- content @s -->

                    <div class="nk-content nk-content-fluid">
        <div class="container-xl wide-lg">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-sub"><span>Welcome!</span>
                    </div>
                    <div class="nk-block-between-md g-4">
                        <div class="nk-block-head-content">
                            <h2 class="nk-block-title fw-normal"><?php echo $firstname ?> <?php echo $lastname ?></h2>
                            <div class="nk-block-des">
                                <p>At a glance summary of your account!</p>
                            </div>
                        </div><!-- .nk-block-head-content -->
                        <div class="nk-block-head-content">
                            <ul class="nk-block-tools gx-3">
                                <li><a href="funds-transfer.php" class="btn btn-danger"><span>Transfer</span> <em class="icon ni ni-arrow-long-right"></em></a></li>
                                
                            </ul>
                        </div><!-- .nk-block-head-content -->
                    </div><!-- .nk-block-between -->
                </div><!-- .nk-block-head -->
                <div class="nk-block">
                    <div class="row gy-gs">
                        <div class="col-lg-5 col-xl-4">
                            <div class="nk-block">
                                <div class="nk-block-head-xs">
                                    <div class="nk-block-head-content">
                                        <h5 class="nk-block-title title">Overview</h5>
                                    </div>
                                </div><!-- .nk-block-head -->
                                <div class="nk-block">
                                    <div class="card card-bordered text-light is-dark h-100">
                                        <div class="card-inner">
                                            <div class="nk-wg7">
                                                <div class="nk-wg7-stats">
                                                    <div class="nk-wg7-title">Available balance in USD</div>
                                                    <div class="number-lg amount"> <?php echo $curr ?> <?php echo number_format($balc,2) ?></div>
                                                </div>
                                                <div class="nk-wg7-stats-group">
                                                    <div class="nk-wg7-stats w-50">
                                                        <div class="nk-wg7-title">Card(s)</div>
                                                        <div class="number">1 - <?php
// Ensure $pdo and $id are defined and valid
$stmt = $pdo->prepare("SELECT CARD_TYP FROM logins WHERE id = ?");
$stmt->execute([$id]);
$ordrow = $stmt->fetch(PDO::FETCH_ASSOC);

if ($ordrow) {
    if ($ordrow['CARD_TYP'] == 1) {
        echo "<img src='tools/visacard.png' height='20px' width='70px' alt='Visa Card'>";
    } elseif ($ordrow['CARD_TYP'] == 2) {
        echo "<img src='tools/mastercard.png' height='50px' width='70px' alt='Mastercard'>";
    }
}
?>
</div>
                                                    </div>
                                                    <div class="nk-wg7-stats w-50">
                                                        <div class="nk-wg7-title">Account Number</div>
                                                        <div class="number"><?php echo substr($acc_no,+0,-5) ?>***<?php echo substr($acc_no,-2) ?></div>
                                                    </div>
                                                </div>
                                                
                                            </div><!-- .nk-wg7 -->
                                        </div><!-- .card-inner -->
                                    </div><!-- .card -->
                                </div><!-- .nk-block -->
                            </div><!-- .nk-block -->
                        </div><!-- .col -->
                        <div class="col-lg-7 col-xl-8">
                            <div class="nk-block">
                                <div class="nk-block-head-xs">
                                    <div class="nk-block-between-md g-2">
                                        <div class="nk-block-head-content">
                                            <h5 class="nk-block-title title">Quick Links</h5>
                                        </div>
                                        
                                        </div>
                                    </div>
                                </div><!-- .nk-block-head -->
                                <div class="row g-2">
                                    <div class="col-sm-4">
                                        <div class="card bg-light">
                                            <div class="nk-wgw sm">
                                                <a class="nk-wgw-inner" href="card.php">
                                                    <div class="nk-wgw-name">
                                                        <div class="nk-wgw-icon">
                                                            <em class="icon ni ni-cc-secure-fill"></em>
                                                        </div>
                                                        <h5 class="nk-wgw-title title">Card(s)</h5>
                                                    </div>
                                                    <div class="nk-wgw-balance">
                                                        <div class="amount">1</div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div><!-- .col -->
                                    <!--<div class="col-sm-4">-->
                                    <!--    <div class="card bg-light">-->
                                    <!--        <div class="nk-wgw sm">-->
                                    <!--            <a class="nk-wgw-inner" href="notification.php">-->
                                    <!--                <div class="nk-wgw-name">-->
                                    <!--                    <div class="nk-wgw-icon">-->
                                    <!--                        <em class="icon ni ni-bell"></em>-->
                                    <!--                    </div>-->
                                    <!--                    <h5 class="nk-wgw-title title">Unread Notifications</h5>-->
                                    <!--                </div>-->
                                    <!--                <div class="nk-wgw-balance">-->
                                    <!--                    <div class="amount">0</div>-->
                                    <!--                </div>-->
                                    <!--            </a>-->
                                    <!--        </div>-->
                                    <!--    </div>-->
                                    <!--</div>-->
                                    
                                    <!-- .col -->
                                    
                                </div><!-- .row -->
                            </div><!-- .nk-block -->

                            

                        </div><!-- .col -->
                    </div><!-- .row -->
                </div><!-- .nk-block -->
                
                
                
                
                
                <div class="nk-block nk-block-lg mt-4">
                    <div class="row gy-gs">
                        <div class="col-md-6">
                            <div class="card-head">
                                <div class="card-title  mb-0">
                                    <h5 class="title">Recent Transactions</h5>
                                </div>
                                <div class="card-tools">
                                    <ul class="card-tools-nav">
                                        
                                        <li class="active"><a href="e_statement.php">View All</a></li>
                                    </ul>
                                </div>
                            </div><!-- .card-head -->
                           
                           
                           
                            <div class="tranx-list card card-bordered">

                                <div class="table-responsive">
                                    
                                 <?php
// Make sure $pdo and $id are defined and sanitized
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE log_id = ? ORDER BY id DESC LIMIT 5");
$stmt->execute([$id]);
$transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$transactions) {
    echo "<strong>No History</strong>";
} 
?>

   
<table class="table table-striped table-hover">
    <thead>
        <tr>
            <th>AMOUNT</th>
            <th>TYPE</th>
            <th>STATUS</th>
            <th>ACTION</th>
        </tr>
    </thead>
    <tbody>
    <?php
    $stmt = $pdo->prepare("SELECT * FROM transactions WHERE log_id = ? ORDER BY id DESC LIMIT 5");
    $stmt->execute([$id]);
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$transactions) {
        echo "<tr><td colspan='4'><strong>No History</strong></td></tr>";
    } else {
        foreach ($transactions as $row) {
            $amount = htmlspecialchars($row['cur']) . " " . number_format($row['trans_amount'], 2);

            // Determine type from tran_type or tran_type2 (prioritize tran_type if present)
            $type = '';
            if ($row['tran_type'] == 1 || $row['tran_type2'] == 1) {
                $type = "<span style='color:#ff0000'>DEBIT</span>";
            } elseif ($row['tran_type'] == 2 || $row['tran_type2'] == 2) {
                $type = "<span style='color:#33cc33'>CREDIT</span>";
            }

            // Always assuming status is "successful" here
            // $status = "<span class='badge badge-dim badge-sm bg-outline-success'>successful</span>";
            
            
            // Determine status color
        $statusRaw = strtolower(trim($row['status']));
        if ($statusRaw === 'successful') {
            $statusBadge = "<span class='badge bg-success text-white'>Successful</span>";
        } elseif ($statusRaw === 'pending' || $statusRaw === '0' || $row['status'] == 0) {
            $statusBadge = "<span class='badge bg-danger text-white'>Pending</span>";
        } else {
            $statusBadge = "<span class='badge bg-secondary text-white'>Unknown</span>";
        }

            // Action button
            $action = "<a href='trx_receipt.php?id=" . intval($row['id']) . "'>
                           <span class='badge badge-dim badge-sm bg-outline-success'>view</span>
                       </a>";

            echo "<tr>
                    <td>{$amount}</td>
                    <td>{$type}</td>
                    <td>{$statusBadge}</td>
                    <td>{$action}</td>
                  </tr>";
        }
    }
    ?>
    </tbody>
</table>

                                    
                                    
                                    
                                    
                                </div>

                            </div><!-- .tranx-list -->
                        </div><!-- .col -->
                        <div class="col-md-6">

                            <div class="card card-bordered h-100">
                                <div class="card-inner">
                                    <div class="card-title-group">
                                        <div class="card-title card-title-sm">
                                            <h6 class="title">Offices</h6>
                                        </div>
                                        <div class="card-tools">
                                            <div class="drodown">
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="analytics-map">
                                        <div class="vector-map" id="worldMap"></div>
                                        <table class="analytics-map-data-list">
                                            <tr class="analytics-map-data">
                                                <td class="country">United States</td>
                                                <td class="amount">12,094</td>
                                                <td class="percent">23.54%</td>
                                            </tr>
                                            <tr class="analytics-map-data">
                                                <td class="country">India</td>
                                                <td class="amount">7,984</td>
                                                <td class="percent">7.16%</td>
                                            </tr>
                                            <tr class="analytics-map-data">
                                                <td class="country">Turkey</td>
                                                <td class="amount">6,338</td>
                                                <td class="percent">6.54%</td>
                                            </tr>
                                            <tr class="analytics-map-data">
                                                <td class="country">Bangladesh</td>
                                                <td class="amount">4,749</td>
                                                <td class="percent">5.29%</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- .card -->
                        </div><!-- .col -->
                    </div><!-- .row -->
                </div><!-- .nk-block -->

                

                <div class="nk-block">
                    <div class="card card-bordered">
                        <div class="card-inner card-inner-lg">
                            <div class="align-center flex-wrap flex-md-nowrap g-4">
                                <div class="nk-block-image w-120px flex-shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 120 118">
                                        <path d="M8.916,94.745C-.318,79.153-2.164,58.569,2.382,40.578,7.155,21.69,19.045,9.451,35.162,4.32,46.609.676,58.716.331,70.456,1.845,84.683,3.68,99.57,8.694,108.892,21.408c10.03,13.679,12.071,34.71,10.747,52.054-1.173,15.359-7.441,27.489-19.231,34.494-10.689,6.351-22.92,8.733-34.715,10.331-16.181,2.192-34.195-.336-47.6-12.281A47.243,47.243,0,0,1,8.916,94.745Z" transform="translate(0 -1)" fill="#f6faff" />
                                        <rect x="18" y="32" width="84" height="50" rx="4" ry="4" fill="#fff" />
                                        <rect x="26" y="44" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                        <rect x="50" y="44" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                        <rect x="74" y="44" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                        <rect x="38" y="60" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                        <rect x="62" y="60" width="20" height="12" rx="1" ry="1" fill="#e5effe" />
                                        <path d="M98,32H22a5.006,5.006,0,0,0-5,5V79a5.006,5.006,0,0,0,5,5H52v8H45a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2H73a2,2,0,0,0,2-2V94a2,2,0,0,0-2-2H66V84H98a5.006,5.006,0,0,0,5-5V37A5.006,5.006,0,0,0,98,32ZM73,94v4H45V94Zm-9-2H54V84H64Zm37-13a3,3,0,0,1-3,3H22a3,3,0,0,1-3-3V37a3,3,0,0,1,3-3H98a3,3,0,0,1,3,3Z" transform="translate(0 -1)" fill="#798bff" />
                                        <path d="M61.444,41H40.111L33,48.143V19.7A3.632,3.632,0,0,1,36.556,16H61.444A3.632,3.632,0,0,1,65,19.7V37.3A3.632,3.632,0,0,1,61.444,41Z" transform="translate(0 -1)" fill="#6576ff" />
                                        <path d="M61.444,41H40.111L33,48.143V19.7A3.632,3.632,0,0,1,36.556,16H61.444A3.632,3.632,0,0,1,65,19.7V37.3A3.632,3.632,0,0,1,61.444,41Z" transform="translate(0 -1)" fill="none" stroke="#6576ff" stroke-miterlimit="10" stroke-width="2" />
                                        <line x1="40" y1="22" x2="57" y2="22" fill="none" stroke="#fffffe" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" />
                                        <line x1="40" y1="27" x2="57" y2="27" fill="none" stroke="#fffffe" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" />
                                        <line x1="40" y1="32" x2="50" y2="32" fill="none" stroke="#fffffe" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" />
                                        <line x1="30.5" y1="87.5" x2="30.5" y2="91.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                        <line x1="28.5" y1="89.5" x2="32.5" y2="89.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                        <line x1="79.5" y1="22.5" x2="79.5" y2="26.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                        <line x1="77.5" y1="24.5" x2="81.5" y2="24.5" fill="none" stroke="#9cabff" stroke-linecap="round" stroke-linejoin="round" />
                                        <circle cx="90.5" cy="97.5" r="3" fill="none" stroke="#9cabff" stroke-miterlimit="10" />
                                        <circle cx="24" cy="23" r="2.5" fill="none" stroke="#9cabff" stroke-miterlimit="10" />
                                    </svg>
                                </div>
                                <div class="nk-block-content">
                                    <div class="nk-block-content-head px-lg-4">
                                        <h5>We’re here to help you!</h5>
                                        <p class="text-soft">Ask a question or file a support ticket, manage request, report an issues. Our team support team will get back to you by email.</p>
                                    </div>
                                </div>
                                <div class="nk-block-content flex-shrink-0">
                                    <a href="ticket.php" class="btn btn-lg btn-outline-primary">Get Support Now</a>
                                </div>
                            </div>
                        </div><!-- .card-inner -->
                    </div><!-- .card -->
                </div><!-- .nk-block -->
            </div>
        </div>
    </div>

                <!-- content @e -->

               <?php require ("footer.php") ?>